%%
%% This is file `eas-proc.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% eas-proc.dtx  (with options: `class')
%% eas-proc -- Proceedings of the Estonian Academy of Sciences
%% Copyright (C) 2024-2025 by Marei Peischl <eas-proc@peitex.de>
\NeedsTeXFormat{LaTeX2e}[2023/11/01]
\ProvidesClass{eas-proc}
[2025-11-25 v1.3d Proceedings of the Estonian Academy of Sciences]

\ExplSyntaxOn
\bool_new:N \g__ptxcd_numeric_bib_bool
\bool_new:N \g__ptxcd_biblatex_bool
\def\@copyrightauthorstring{default}
\keys_define:nn {ptxcd/eas-proc}  {
  titlefootnotemarks .bool_gset:N = \g__ptxcd_titlefootnotemarks_bool,
  titlefootnotemarks .initial:n = true,
  single-author  .meta:n = {copyrightauthorstring=Authors,titlefootnotemarks=false},
  multi-author .meta:n = {copyrightauthorstring=Authors,titlefootnotemarks=true},
  copyrightauthorstring .tl_gset:N = \@copyrightauthorstring,
  bibstyle .choice:,
  bibstyle / numeric .code:n = \bool_gset_true:N \g__ptxcd_biblatex_bool \bool_gset_true:N \g__ptxcd_numeric_bib_bool,
  bibstyle / authoryear  .code:n = \bool_gset_true:N \g__ptxcd_biblatex_bool \bool_gset_false:N \g__ptxcd_numeric_bib_bool,
  bibstyle / manual .code:n = \bool_gset_false:N \g__ptxcd_biblatex_bool,
  bibstyle .initial:n = authoryear,
  parshape-offset .int_gset:N = \g__ptxcd_parshape_offset_int,
  parshape-offset .initial:n = 0,
}
\ExplSyntaxOff
\DeclareUnknownKeyHandler[ptxcd/eas-proc]{%
  \PassOptionsToClass{\CurrentOption}{scrartcl}
}
\ProcessKeyOptions[ptxcd/eas-proc]
\LoadClass{scrartcl}
\KOMAoptions{numbers=enddot,twoside=true}
\ExplSyntaxOn
\color_set:nnn {peas-blue} {cmyk} {1,.5,0,0}
\ExplSyntaxOff
\RequirePackage{xcolor}
\definecolor{peas-blue}{cmyk}{1,.5,0,0}
\RequirePackage{iftex}
\RequirePackage[a4paper, twoside]{geometry}
\geometry{
  twoside=true,
  top=\dimexpr13.097mm+12bp\relax,
  hmargin=29mm,
  textheight=264mm,
  headsep=9bp%\baselineskip
}
\newcommand{\peas@proc@newgeometry}{
  \newgeometry{
    top=\dimexpr13.097mm+12bp\relax,%TODO top is measured differently
    twoside=false,
    right=17mm,
    left=75mm,
    textheight=266.2mm,
  }
}
\ExplSyntaxOn
\newif\iftracetest
\dim_const:Nn \c__ptxcd_firstpage_extraindent_dim {58mm-24mm}
\dim_const:Nn \c_ptxcd_HMargin_dim {17mm}
\dim_const:Nn \c_ptxcd_Linewidth_dim  {\textwidth}
\dim_new:N \g__ptxcd_page_free_dim
\int_new:N \g__ptxcd_free_lines_int
\bool_new:N \g__ptxcd_skip_hook_bool
\bool_new:N \g__ptxcd_in_section_bool

\cs_new:Nn \__ptxcd_remove_first_page_adjust_hooks: {
  \RemoveFromHook{cmd/section/before}[eas-proc-firstpage]
  \RemoveFromHook{cmd/subsection/before}[eas-proc-firstpage]
  \RemoveFromHook{env/verbatim/before}[eas-proc-firstpage]
  \RemoveFromHook{env/verbatim/after}[eas-proc-firstpage]
  \cs_gset_eq:NN \__ptxcd_remove_first_page_adjust_hooks: \prg_do_nothing:
}

\AddToHook{env/verbatim/before}[eas-proc-firstpage]{
  \bool_gset_true:N \g__ptxcd_skip_hook_bool
}

\AddToHook{env/verbatim/after}[eas-proc-firstpage]{
  \bool_gset_false:N \g__ptxcd_skip_hook_bool
  \par\nointerlineskip\leavevmode\par
}

\AddToHook{env/itemize/begin}[eas-proc-firstpage]{
  \bool_set_true:N \g__ptxcd_skip_hook_bool
}

\AddToHook{env/description/begin}[eas-proc-firstpage]{
  \bool_set_true:N \g__ptxcd_skip_hook_bool
}

\AddToHook{env/enumerate/begin}[eas-proc-firstpage]{
  \bool_set_true:N \g__ptxcd_skip_hook_bool
}

\AddToHook{cmd/section/before}[eas-proc-firstpage]{
\dim_gset:Nn \g__ptxcd_page_free_dim {-\pagegoal + \pagetotal}
\int_gset:Nn \g__ptxcd_free_lines_int {\fp_eval:n {ceil(\g__ptxcd_page_free_dim/\baselineskip)}}
\int_compare:nNnF {\g__ptxcd_free_lines_int} < {-5} {
\pagebreak
 \__ptxcd_remove_first_page_adjust_hooks:
\bool_gset_true:N \g__ptxcd_in_section_bool
}
}

\AddToHook{cmd/subsection/before}[eas-proc-firstpage]{
\dim_gset:Nn \g__ptxcd_page_free_dim {-\pagegoal + \pagetotal}
\int_gset:Nn \g__ptxcd_free_lines_int {\fp_eval:n {ceil(\g__ptxcd_page_free_dim/\baselineskip)}}
\int_compare:nNnF {\g__ptxcd_free_lines_int} < {-5} {
\pagebreak
\__ptxcd_remove_first_page_adjust_hooks:
}
\bool_gset_true:N \g__ptxcd_in_section_bool
}

\bool_new:N  \g__ptxcd_break_after_next_bool
\newcounter{titlebreak}
\NewMarkClass{titlebreak}

\cs_new:Nn \__ptxcd_adjust_textwidth: {
\stepcounter{titlebreak}%
\InsertMark{titlebreak}{titlebreak}
    \AddToHook{para/after}[eas-proc-firstpage]{
\dim_gset:Nn \g__ptxcd_page_free_dim {-\pagegoal + \pagetotal  +.3\baselineskip}
    \int_gset:Nn \g__ptxcd_free_lines_int {\fp_eval:n {ceil(\g__ptxcd_page_free_dim/\baselineskip)}}
    \bool_if:NTF  \g__ptxcd_break_after_next_bool {
    \bool_gset_false:N \g__ptxcd_break_after_next_bool
\InsertMark{titlebreak}{-\arabic{titlebreak}}
    } {
\int_compare:nNnF {\g__ptxcd_free_lines_int} < {-4} {
\int_compare:nNnTF {\g__ptxcd_free_lines_int} < {-2} {
\bool_gset_true:N \g__ptxcd_break_after_next_bool
} {
\bool_gset_false:N \g__ptxcd_break_after_next_bool
\InsertMark{titlebreak}{-\arabic{titlebreak}}
\__ptxcd_remove_first_page_adjust_hooks:
\pagebreak
\titlepage@restore
}
}
}
    }
\AddToHook{para/before}[eas-proc-firstpage]{
\IfMarksEqualTF{titlebreak}{first}{last}
{\InsertMark{titlebreak}{-\arabic{titlebreak}}}
{
\__ptxcd_remove_first_page_adjust_hooks:
\titlepage@restore
\bool_gset_true:N \g__ptxcd_skip_hook_bool
\RemoveFromHook{para/before}[eas-proc-firstpage]
\RemoveFromHook{para/after}[eas-proc-firstpage]
}
\bool_if:NF  \g__ptxcd_skip_hook_bool {
\if@nobreak
\bool_gset_false:N \g__ptxcd_in_section_bool
\fi
\dim_gset:Nn \g__ptxcd_page_free_dim {-\pagegoal + \pagetotal -\dp\strutbox}
\dim_compare:nNnTF {-\g__ptxcd_page_free_dim} > {\dim_eval:n {\bool_if:NTF \g__ptxcd_in_section_bool {5\baselineskip} {2\baselineskip} }} {
\int_gset:Nn \g__ptxcd_free_lines_int {\fp_eval:n {ceil(\g__ptxcd_page_free_dim/\baselineskip)}}
\int_compare:nT {\g__ptxcd_free_lines_int<0} {
\int_gsub:Nn \g__ptxcd_free_lines_int {\g__ptxcd_parshape_offset_int}
\parshape\int_eval:n {-\g__ptxcd_free_lines_int +1}~
\prg_replicate:nn {-\g__ptxcd_free_lines_int} {\z@~\hsize}
~\z@~\dim_eval:n {\hsize + 58mm -24mm}
}
} {
\int_gset:Nn \g__ptxcd_free_lines_int {\fp_eval:n {floor(\g__ptxcd_page_free_dim/\baselineskip)}}
\bool_if:NTF \g__ptxcd_in_section_bool {
\use_none:nn
} \use:n
{
\int_compare:nTF {-\g__ptxcd_free_lines_int=2} {
\int_gsub:Nn \g__ptxcd_free_lines_int {\g__ptxcd_parshape_offset_int}
\parshape\int_eval:n {-\g__ptxcd_free_lines_int +1}~
\prg_replicate:nn {-\g__ptxcd_free_lines_int} {\z@~\hsize}
~\z@~\dim_eval:n {\hsize + 58mm -24mm}
} {
}
     }
}
}
}%
}
\ExplSyntaxOff
\RequirePackage{afterpage}
\RequirePackage{graphicx}
\RequirePackage{mathtools}
\RequirePackage{amsfonts}
\RequirePackage{amssymb}

\PassOptionsToPackage{proportional}{inter}
\RequirePackage{inter}
\RequirePackage{newtx}
\@ifpackageloaded{amsthm}{}{
\AddToHook{package/amsthm/before}{
\let\ptxcd@textsquare\textsquare
\let\ptxcd@openbox\openbox
\let\textsquare\@undefined
\let\openbox\@undefined
}
\AddToHook{package/amsthm/after}{
\let\textsquare\ptxcd@textsquare
\let\openbox\ptxcd@openbox
}
}

\ExplSyntaxOn
\bool_if:NTF \g__ptxcd_numeric_bib_bool  {
\PassOptionsToPackage{style=numeric-comp,locallabelwidth=true}{biblatex}
} {
\PassOptionsToPackage{style=authoryear, dashed=false}{biblatex}
}


\let\ptxcd@save@cite\cite

\ExplSyntaxOff
\RequirePackage[
giveninits=true,
uniquename=init,
maxbibnames=6,
maxcitenames=2,
urldate=iso,
seconds=true,
isbn=false,
,]{biblatex}

\renewcommand*{\finalandcomma}{}
\renewcommand*{\intitlepunct}{\addspace}
\ExplSyntaxOn
\bool_new:N \l__ptxcd_finentrypunct_bool
\newcommand*{\peas@finentrypunct}{
\bool_set_true:N  \l__ptxcd_finentrypunct_bool
\iftoggle{bbx:eprint}{
\iffieldundef{url}{}{\bool_set_false:N  \l__ptxcd_finentrypunct_bool}
\iffieldundef{doi}{}{\bool_set_false:N  \l__ptxcd_finentrypunct_bool}
\iffieldundef{eprint}{}{\bool_set_false:N  \l__ptxcd_finentrypunct_bool}
\bool_if:NF \l__ptxcd_finentrypunct_bool {
\iffieldundef{urlyear}{}{
\bool_set_true:N  \l__ptxcd_finentrypunct_bool
}
}
}{}
\bool_if:NT \l__ptxcd_finentrypunct_bool {\addperiod}
}
\let\finentrypunct\peas@finentrypunct

\bool_if:NTF \g__ptxcd_numeric_bib_bool  {
\renewbibmacro*{journal+issuetitle}{%
  \usebibmacro{journal}%
  \setunit*{\addspace}%
  \iffieldundef{series}
    {}
    {\newunit
     \printfield{series}%
     \setunit{\addspace}}%
\setunit*{\addcomma\addspace}%
  \usebibmacro{date}%
  \setunit{\addcolon\space}%
  \usebibmacro{volume+number+eid}%
  \setunit{\addspace}%
  \usebibmacro{issue}%
  \newunit
}
}{
  \renewbibmacro*{issue+date}{%
    \printtext{%
      \printfield{issue}%
      \setunit*{\addspace}%
      \usebibmacro{date}}%
    \newunit
   }
  \renewbibmacro*{date+extradate}{%
    \iffieldundef{labelyear}
      {}
      {\printtext{\printlabeldateextra}}}%
}
\ExplSyntaxOff

\DeclareFieldFormat{title}{#1}
\DefineBibliographyStrings{english}{%
urlseen          = {accessed},
techreport = {technical report}
}
\DeclareFieldFormat{url}{\url{#1}}
\ExplSyntaxOn
\DeclareFieldFormat{doi}{
\str_if_in:nnTF {#1} {doi.org} {
\url{#1}
} {
\url{https://doi.org/#1}
}
}
\ExplSyntaxOff
\renewbibmacro*{doi+eprint+url}{%
\iftoggle{bbx:doi}
{\printfield{doi}}
{}%
\newunit\newblock
\iffieldundef{doi}{%
\iftoggle{bbx:eprint}
{\usebibmacro{eprint}}
{}%
\newunit\newblock
\iftoggle{bbx:url}
{\usebibmacro{url+urldate}}
{}%
}{}%
}

\renewbibmacro*{publisher+location+date}{%
\printlist{publisher}%
\iflistundef{location}
{\setunit*{\addcomma\space}}%
{\setunit*{\addcolon\space}}%
\printlist{location}%
\setunit*{\addcomma\space}%
\usebibmacro{date}%
\newunit
}

\renewbibmacro*{institution+location+date}{%
  \printlist{institution}%
  \setunit*{\addcomma\space}%
  \printlist{location}%
  \setunit*{\addcomma\space}%
  \usebibmacro{date}%
  \newunit
  }

\renewbibmacro*{organization+location+date}{%
\printlist{organization}%
\iflistundef{location}
{\setunit*{\addcomma\space}}%
{\setunit*{\addcolon\space}}%
\printlist{location}%
\setunit*{\addcomma\space}%
\usebibmacro{date}%
\newunit
}

\DeclareFieldFormat
[article,inbook,incollection,inproceedings,patent,unpublished]
{title}{#1}

\DeclareFieldFormat
[thesis,book,inbook]
{title}{\mkbibemph{#1}}

\DeclareBibliographyDriver{inbook}{%
\usebibmacro{bibindex}%
\usebibmacro{begentry}%
\usebibmacro{author/translator+others}%
\setunit{\printdelim{nametitledelim}}\newblock
\usebibmacro{title}%
\newunit
\printlist{language}%
\newunit\newblock
\usebibmacro{byauthor}%
\newunit\newblock
\usebibmacro{in:}%
\usebibmacro{bybookauthor}%
\newunit\newblock
\usebibmacro{maintitle+booktitle}%
\setunit{\addspace}%
\usebibmacro{byeditor+others}%
\newunit\newblock
\printfield{edition}%
\newunit
\iffieldundef{maintitle}
{\printfield{volume}%
\printfield{part}}
{}%
\newunit
\printfield{volumes}%
\newunit
\usebibmacro{chapter+pages}%
\newunit\newblock
\usebibmacro{series+number}%
\newunit\newblock
\printfield{note}%
\newunit\newblock
\usebibmacro{publisher+location+date}%
\newunit\newblock
\iftoggle{bbx:isbn}
{\printfield{isbn}}
{}%
\newunit\newblock
\usebibmacro{doi+eprint+url}%
\newunit\newblock
\usebibmacro{addendum+pubstate}%
\setunit{\bibpagerefpunct}\newblock
\usebibmacro{pageref}%
\newunit\newblock
\iftoggle{bbx:related}
{\usebibmacro{related:init}%
\usebibmacro{related}}
{}%
\usebibmacro{finentry}%
}

\DeclareBibliographyDriver{incollection}{%
\usebibmacro{bibindex}%
\usebibmacro{begentry}%
\usebibmacro{author/translator+others}%
\setunit{\printdelim{nametitledelim}}\newblock
\usebibmacro{title}%
\newunit
\printlist{language}%
\newunit\newblock
\usebibmacro{byauthor}%
\newunit\newblock
\usebibmacro{in:}%
\usebibmacro{maintitle+booktitle}%
\setunit{\addspace}%
\usebibmacro{byeditor+others}%
\newunit\newblock
\printfield{edition}%
\newunit
\iffieldundef{maintitle}
{\printfield{volume}%
\printfield{part}}
{}%
\newunit
\printfield{volumes}%
\newunit
\usebibmacro{chapter+pages}%
\newunit\newblock
\usebibmacro{series+number}%
\newunit\newblock
\printfield{note}%
\newunit\newblock
\usebibmacro{publisher+location+date}%
\newunit\newblock
\iftoggle{bbx:isbn}
{\printfield{isbn}}
{}%
\newunit\newblock
\usebibmacro{doi+eprint+url}%
\newunit\newblock
\usebibmacro{addendum+pubstate}%
\setunit{\bibpagerefpunct}\newblock
\usebibmacro{pageref}%
\newunit\newblock
\iftoggle{bbx:related}
{\usebibmacro{related:init}%
\usebibmacro{related}}
{}%
\usebibmacro{finentry}%
}

\DeclareBibliographyDriver{inproceedings}{%
\usebibmacro{bibindex}%
\usebibmacro{begentry}%
\usebibmacro{author/translator+others}%
\setunit{\printdelim{nametitledelim}}\newblock
\usebibmacro{title}%
\newunit
\printlist{language}%
\newunit\newblock
\usebibmacro{byauthor}%
\newunit\newblock
\usebibmacro{in:}%
\usebibmacro{maintitle+booktitle}%
\newunit\newblock
\usebibmacro{event+venue+date}%
\setunit{\addspace}
\usebibmacro{byeditor+others}%
\newunit\newblock
\iffieldundef{maintitle}
{\printfield{volume}%
\printfield{part}}
{}%
\newunit
\printfield{volumes}%
\newunit
\usebibmacro{chapter+pages}%
\newunit\newblock
\usebibmacro{series+number}%
\newunit\newblock
\printfield{note}%
\newunit\newblock
\printlist{organization}%
\newunit
\usebibmacro{publisher+location+date}%
\newunit\newblock
\iftoggle{bbx:isbn}
{\printfield{isbn}}
{}%
\newunit\newblock
\usebibmacro{doi+eprint+url}%
\newunit\newblock
\usebibmacro{addendum+pubstate}%
\setunit{\bibpagerefpunct}\newblock
\usebibmacro{pageref}%
\newunit\newblock
\iftoggle{bbx:related}
{\usebibmacro{related:init}%
\usebibmacro{related}}
{}%
\usebibmacro{finentry}%
}

\renewbibmacro*{byeditor+others}{%
\ifnameundef{editor}
{}
{\setunit{}%
\mkbibparens{%
\printnames{editor}%
\setunit*{\addcomma\addspace}%
\usebibmacro{editor+othersstrg}%
\clearname{editor}%
}\newunit
}%
}%

   \DeclareBibliographyDriver{article}{%
     \usebibmacro{bibindex}%
     \usebibmacro{begentry}%
     \usebibmacro{author/translator+others}%
     \setunit{\printdelim{nametitledelim}}\newblock
     \usebibmacro{title}%
     \newunit
     \printlist{language}%
     \newunit\newblock
     \usebibmacro{byauthor}%
     \newunit\newblock
     \usebibmacro{bytranslator+others}%
     \newunit\newblock
     \printfield{version}%
     \newunit\newblock
\usebibmacro{journal+issuetitle}%
\newunit
\usebibmacro{byeditor+others}%
\newunit
\usebibmacro{note+pages}%
\newunit\newblock
\iftoggle{bbx:isbn}
  {\printfield{issn}}
  {}%
\newunit\newblock
\usebibmacro{doi+eprint+url}%
\newunit\newblock
\usebibmacro{addendum+pubstate}%
\setunit{\bibpagerefpunct}\newblock
\usebibmacro{pageref}%
\newunit\newblock
\iftoggle{bbx:related}
  {\usebibmacro{related:init}%
   \usebibmacro{related}}
  {}%
\usebibmacro{finentry}%
}

\DeclareFieldFormat[article]{volume}{\mkbibbold{#1}}
 \DeclareFieldFormat[article]{number}{\mkbibparens{#1}}
\renewbibmacro*{volume+number+eid}{%
\setunit{\addcomma\addspace}
  \printfield{volume}%
  \setunit*{}%
  \printfield{number}%
  \setunit{\bibeidpunct}%
  \printfield{eid}}

\DeclareFieldFormat[article]{pages}{#1}

\DeclareNameAlias{author}{family-given}
\DeclareNameAlias{editor}{family-given}
\RequirePackage{multicol}

\ExplSyntaxOn
\bool_if:NF \g__ptxcd_biblatex_bool {
\let\cite\ptxcd@save@cite
\let\parencite\cite
\let\footcite\cite
\let\footcitetext\cite
\let\textcite\cite
\let\supercite\cite
\let\smartcite\cite
\renewcommand*{\printbibliography}{
\ClassWarning{eas-proc.cls}{You~use~bibstyle=manual~together~with~\string\printbibliography.~This~is~not~supported!}
}
}

\renewcommand*{\bibfont}{\fontsize{9bp}{11bp}\selectfont}
\setlength{\bibhang}{5mm}
\setlength{\biblabelsep}{2pt}

\cs_new:Nn \ptxcd_before_bibliography: {
\begingroup
\bibfont
\def\@openbib@code{%
\bibfont
\setlength{\itemsep}{\bibitemsep}%
\setlength{\parsep}{\bibparsep}%
\setlength{\labelsep}{\biblabelsep}%
\setlength{\leftmargin}{\dimexpr\bibhang}%
\setlength{\itemindent}{\dimexpr-\bibhang+\labelwidth+\labelsep}%
}
\renewcommand*{\@biblabel}[1]{##1.}
\vskip2\baselineskip
\@totalleftmargin=-12mm
\setlength{\linewidth}{\dimexpr\textwidth+24mm}
\setlength{\columnsep}{6mm}
\begin{multicols}{2}
\bibfont
}

\cs_new:Nn \ptxcd_after_bibliography: {
\end{multicols}
\endgroup
}

\AddToHook{env/thebibliography/before}{
\ptxcd_before_bibliography:
}

\AddToHook{env/thebibliography/after}{
\ptxcd_after_bibliography:
}

\let\orig@printbibliography\printbibliography
\RenewDocumentCommand{\printbibliography}{O{}}{
\ptxcd_before_bibliography:
\orig@printbibliography[#1]
\ptxcd_after_bibliography:
}

\bool_if:NT \g__ptxcd_numeric_bib_bool  {
\renewcommand*\multicitedelim{\addcomma}
\setlength{\bibitemsep}{\z@}
\defbibenvironment{bibliography}
  {%
  \renewcommand*{\finalandcomma}{}%
  \let\finentrypunct\peas@finentrypunct
  \list
     {\printtext[labelnumberwidth]{%
        \printfield{labelprefix}%
        \printfield{labelnumber}}}
     {\setlength{\labelwidth}{\labelnumberwidth}%
     \DeclareFieldFormat{labelnumberwidth}{##1.}
      \setlength{\labelsep}{\biblabelsep}%
      \setlength{\itemsep}{\bibitemsep}%
      \setlength{\parsep}{\bibparsep}%
      \setlength{\bibhang}{\labelwidth}
      \setlength{\leftmargin}{\labelwidth+\labelsep}%
      \setlength{\itemindent}{0pt}%
      }%
      }
  {\endlist}
  {\item}

}
\bool_if:NF \g__ptxcd_biblatex_bool {
\let\NAT@parse\@undefined
}
\ExplSyntaxOff

\ifx\NAT@parse\@undefined
\patchcmd{\@citex}{\def\@citea{,\penalty\@m\ }}{\def\@citea{,\penalty\@m}}{}{%
\ClassWarningNoLine{eas-proc.cls}{Patching \string\@citex\ failed. There will be spaces in multicites.}
}%
\fi
\PassOptionsToPackage{multiple}{footmisc}
\RequirePackage{footmisc}
\PassOptionsToPackage{hidelinks,hyperfootnotes=false}{hyperref}
\RequirePackage{hyperref}
\urlstyle{same}

\RequirePackage[all]{nowidow}
\RequirePackage{scrlayer-scrpage}

\let\normalsize\@undefined
\DeclareRobustCommand\normalsize{%
  \@setfontsize\normalsize{11bp}{13.5bp}%
  \abovedisplayskip 11\p@ \@plus3\p@ \@minus6\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
  \belowdisplayskip \abovedisplayskip
  \let\@listi\@listI
}
\DeclareRobustCommand\small{%
  \@setfontsize\small{9bp}{12.5bp}%
  \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
  \def\@listi{\leftmargin\leftmargini
    \topsep 6\p@ \@plus2\p@ \@minus2\p@
    \parsep 3\p@ \@plus2\p@ \@minus\p@
    \itemsep \parsep}%
  \belowdisplayskip \abovedisplayskip
}
\DeclareRobustCommand\footnotesize{%
  \@setfontsize\footnotesize{8bp}{10bp}%
  \abovedisplayskip 8\p@ \@plus2\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus\p@
  \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
    \topsep 4\p@ \@plus2\p@ \@minus2\p@
    \parsep 2\p@ \@plus\p@ \@minus\p@
    \itemsep \parsep}%
  \belowdisplayskip \abovedisplayskip
}
\DeclareRobustCommand\scriptsize{\@setfontsize\scriptsize{7.5bp}{11bp}}
\DeclareRobustCommand\tiny{\@setfontsize\tiny{6.5bp}{9.4bp}}
\DeclareRobustCommand\large{\@setfontsize\large{11.5bp}{15bp}}
\DeclareRobustCommand\Large{\@setfontsize\Large{13.5bp}{14bp}}
\DeclareRobustCommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\DeclareRobustCommand\huge{\@setfontsize\huge{21bp}{23bp}}
\DeclareRobustCommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\normalsize
\setlength\footnotesep{7.7\p@}
\setlength{\skip\footins}{10\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{8\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{3\p@ \@plus 1\p@ \@minus 1\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep 4.5\p@ \@plus2\p@ \@minus\p@
            \topsep 9\p@   \@plus3\p@ \@minus5\p@
            \itemsep4.5\p@ \@plus2\p@ \@minus\p@}
\let\@listI\@listi
\@listi
\def\@listi{\leftmargin\leftmargini
            \parsep 4.5\p@ \@plus2\p@ \@minus\p@
            \topsep 9\p@   \@plus3\p@ \@minus5\p@
            \itemsep4.5\p@ \@plus2\p@ \@minus\p@}
\let\@listI\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    4.5\p@ \@plus2\p@ \@minus\p@
              \parsep    2\p@   \@plus\p@  \@minus\p@
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
\renewcommand\maketitle{
  \edef\titlepage@restore{%
\noexpand\global\noexpand\oddsidemargin\the\oddsidemargin
\noexpand\global\noexpand\evensidemargin\the\evensidemargin
\noexpand\global\noexpand\textwidth\the\textwidth
\noexpand\global\noexpand\hsize\the\hsize
\noexpand\global\noexpand\columnwidth\the\columnwidth
\noexpand\global\noexpand\linewidth\the\linewidth
\noexpand\gdef\noexpand\scr@section@beforeskip{\scr@section@beforeskip}
\noexpand\gdef\noexpand\scr@subsection@beforeskip{\scr@subsection@beforeskip}
\noexpand\global\noexpand\raggedbottom
\noexpand\setnowidow
\noexpand\global\noexpand\@twosidetrue
}
\flushbottom
\peas@proc@newgeometry
\edef\scr@section@beforeskip{\the\dimexpr\scr@section@beforeskip\relax \noexpand\@plus .5ex}
\edef\scr@subsection@beforeskip{\the\dimexpr\scr@subsection@beforeskip\relax \noexpand\@plus .5ex}
    \begingroup
   \renewcommand\thefootnote{\@alph\c@footnote}%
    \UseName{bool_if:cTF} {g__ptxcd_titlefootnotemarks_bool} {
      \deffootnotemark{\textsuperscript{\intermedium\scriptsize\thefootnotemark}\kern-.2ex}
      \def\multfootsep{\kern.2ex,}% compensate kerning
}{
\deffootnotemark{}
}
      \thispagestyle{eas-proc.title}
      \if@twocolumn
        \ifnum \col@number=\@ne
          \@maketitle
        \else
          \twocolumn[\@maketitle]%
        \fi
      \else
      \newpage
        \global\@topnum\z@   % Prevents figures from going at top of page.
        \@maketitle
      \fi
    \endgroup
\ifx\@abstract\@empty\else
\@abstract
\fi
   \UseName{__ptxcd_adjust_textwidth:}
    \setcounter{footnote}{0}%
    \global\let\thanks\relax
    \global\let\maketitle\relax
    \global\let\@maketitle\relax
    \global\let\@thanks\@empty
    \global\let\@date\@empty
    \global\let\title\relax
    \global\let\author\relax
    \global\let\date\relax
    \global\let\and\relax
  }

\RequirePackage{microtype}
\setkomafont{disposition}{}
\setkomafont{title}{%
\intermedium
\color{peas-blue}
\fontsize{21bp}{23bp}\selectfont
}
\setkomafont{author}{%
\intermedium
\fontsize{11.5bp}{15bp}\selectfont
}
\newkomafont{affiliations}{%
\sffamily\mdseries
\fontsize{7.5bp}{11bp}\selectfont
}

\newkomafont{abstract}{
\sffamily\mdseries
\fontsize{7.5bp}{11bp}\selectfont
}
\newkomafont{infocolumnentry}{\usekomafont{abstract}}
\newkomafont{abstractheading}{%
\color{peas-blue}%
\intersemibold
\fontsize{8bp}{12.5bp}\selectfont
}
\newkomafont{infocolumnheading}{\usekomafont{abstractheading}}
\setkomafont{section}{
\intermedium
\color{peas-blue}
\fontsize{13.5bp}{14bp}\selectfont
}
\setkomafont{subsection}{
\intersemibold
\fontsize{10bp}{13.5bp}\selectfont
}
\setkomafont{subsubsection}{
\interlight
\fontsize{10bp}{13bp}\selectfont
}
\setkomafont{paragraph}{\usekomafont{subsubsection}}
\setkomafont{subparagraph}{\usekomafont{paragraph}}

\setkomafont{caption}{\sffamily\fontsize{7.5bp}{11bp}\selectfont}
\setkomafont{captionlabel}{\bfseries}

\newkomafont{summaryheading}{\color{peas-blue}\leavevmode\intermedium\fontsize{11.5bp}{13bp}\selectfont}
\newkomafont{summaryauthor}{\intersemibold\fontsize{9bp}{11bp}\selectfont}
\newkomafont{summary}{\sffamily\fontsize{7.5bp}{11bp}\selectfont}
\ifTUTeX
\newfontfamily\InterMediumSection[
Numbers = {\inter@otffigurealign},
        UprightFont    = *-Medium ,
        ItalicFont     = *-MediumItalic ,
        BoldFont    = *-Bold ,
        BoldItalicFont     = *-BoldItalic,
WordSpace = 0.88,
LetterSpace=-1.0,
Kerning=On
]{Inter}
\newcommand{\TextTrackingFormat}[1]{#1}
\addtokomafont{title}{%
\fontspec{Inter}[
Numbers = {\inter@otffigurealign},
        UprightFont    = *-Medium ,
        ItalicFont     = *-MediumItalic ,
        BoldFont    = *-Bold ,
        BoldItalicFont     = *-BoldItalic,
WordSpace = 0.82,
LetterSpace=-4.5,
Kerning=On
]%
}
\addtokomafont{author}{\InterMediumSection}
\addtokomafont{section}{\InterMediumSection}
\addtokomafont{subsection}{%
\fontspec{Inter}[
Numbers = {\inter@otffigurealign},
UprightFont    = *-Bold,
ItalicFont     = *-BoldItalic,
WordSpace = 1.2,
LetterSpace=1.2,
Kerning=On
]%
}
\addtokomafont{affiliations}{%
\fontspec{Inter}[
UprightFont = *-Regular,
ItalicFont = *-Italic,
        BoldFont    = *-SemiBold,
        BoldItalicFont     = *-SemiBoldItalic,
WordSpace = 1.03,
LetterSpace=1.0,
Kerning=On
]%
}
\addtokomafont{abstractheading}{\addfontfeature{LetterSpace=10,Kerning=On}}
\addtokomafont{abstract}{\addfontfeature{LetterSpace=1.3,Kerning=On}}
\addtokomafont{caption}{\addfontfeature{LetterSpace=1.3,Kerning=On}}
\else
\newcommand{\TextTrackingFormat}[1]{\textls{#1}}
\setkomafont{title}{%
\SetTracking[
no ligatures,
outer kerning={0,0},
spacing = {-180*,166,},
]{encoding=*}{-45}%
}
\setkomafont{author}{%
\SetTracking[no ligatures,
outer kerning={0,0},
spacing = {-120*,166,},
]{encoding=*}{-10}%
}
\addtokomafont{affiliations}{%
\SetTracking[no ligatures,
outer kerning={0,0},
spacing = {-10*,166,},
]{encoding=*}{#1}%
}%
\addtokomafont{abstract}{
\SetTracking[no ligatures,
outer kerning={0,0},
spacing = {-10*,166,},
]{encoding=*}{#1}
}
\addtokomafont{caption}{
\SetTracking[no ligatures,
outer kerning={0,0},
spacing = {-10*,166,},
]{encoding=*}{30}
}
\addtokomafont{section}{%
\SetTracking[no ligatures,
outer kerning={0,0},
spacing = {-120*,166,},
]{encoding=*}{-10}%
}
\addtokomafont{subsection}{%
\SetTracking[no ligatures,
outer kerning={0,0},
]{encoding=*}{20}%
}
\fi
\ExplSyntaxOn
\def\@maketitle{%
  \null\par\nointerlineskip
  \vskip-\topskip
  \vskip-10.5bp
  \noindent\hskip-12mm
\raggedright
 \null\par\nointerlineskip
 \vskip2mm
    {
\usekomafont{title}
\TextTrackingFormat{\@title}
    \par}%
    \vskip 3mm
\vskip.2pt
{\usekomafont{author}
  \let \footnote \thanks
  \MakeRobust\label
  \@author
  \par}%
  \nointerlineskip
  \vskip3mm%2.2mm
  \vskip-.1pt
\begingroup
\fontsize{7.5bp}{11bp}\selectfont
\setcounter{footnote}{0}
\cs_set:Npn \footnotetext [##1] ##2 {
\bool_if:NT \g__ptxcd_titlefootnotemarks_bool {
\@hangfrom{\makebox[4mm][l]{
\intermedium{\raisebox{.5ex}{\tiny\strut\ptxcd_title_footnotestyle:n {##1}}}}}
}{
\setcounter{footnote}{\int_eval:n {##1-1}}
\refstepcounter{footnote}
\leavevmode\usekomafont{affiliations}%
##2\strut
}\par\vskip.9pt
}
\cs_set_eq:NN \ptxcd_title_footnotestyle:n \@alph
\@thanks
\endgroup
\par
\vskip1mm
}

\ExplSyntaxOff
\DeclareNewLayer[
  align=tl,
  foreground,
  width=52.75mm,
  height=271mm,%textheight,233,9+50,1 = 284   || - 12.816 = 271,284
  hoffset=-29mm,
  voffset=12.816mm,
  contents={\@ptxcd@titlebarcontent},
]{eas-proc.titlebar}
\DeclareNewPageStyleByLayers{eas-proc.title}{eas-proc.titlebar}

\clearpairofpagestyles
\setkomafont{pageheadfoot}{\rmfamily\itshape\fontsize{9bp}{9bp}\selectfont}
\setkomafont{pagenumber}{\upshape\intermedium}
\rohead[\rlap{\makebox[12mm][r]{\pagemark}}]{\rightmark\rlap{\makebox[12mm][r]{\pagemark}}}
\lehead[\llap{\makebox[12mm][l]{\pagemark}}]{\llap{\makebox[12mm][l]{\pagemark}}\leftmark}
\def\leftmark{\@shortauthor}
\def\rightmark{\@shorttitle}

\newcommand{\@ptxcd@titlebarcontent}{%
\parbox[t][\layerheight]{\layerwidth}{%
\raggedright\sffamily\scriptsize

\hskip1mm\includegraphics[width=31mm]{eas-logo}\par
\vskip14bp
{\intersemibold\small
  \@journalname\par}

{\small\@toiminfo\par}

\vskip\baselineskip
\@fulldoi\par% track 2pt

\vskip\baselineskip
\vskip1bp
{\small\@journalurl\par
  \@publishers\par}
\vskip1.8\baselineskip

{\usekomafont{abstractheading}\fontsize{8bp}{10bp}\selectfont
  \MakeUppercase{\@subjfield}\par}

\vskip1.2\baselineskip
{\usekomafont{abstractheading}\fontsize{8bp}{10bp}\selectfont\color{black!50}
  \MakeUppercase{\@subject}\par}

\vskip1.1\baselineskip

{\usekomafont{infocolumnentry}
  \@chronicle% track 2pt
  \par}
\small\par
\vskip\baselineskip
{\intersemibold Keywords:}%TODO macro?
\par
{\usekomafont{infocolumnentry}
  \@keywords%track
  \par
}
\par\vskip\baselineskip
{\intersemibold Corresponding author:\par}
{\usekomafont{infocolumnentry}
  \@correspondingAuthor\\
  \@corcontact
  \par
}
\par\vskip\baselineskip
\vskip-.7pt
{\intersemibold Citation:\par}
{\usekomafont{infocolumnentry}
\@citation
\par
}
\vfill
\tiny
\@copyrightnotice\par
}%
}
\ExplSyntaxOn
\NewDocumentEnvironment{abstractenv}{+b}{
  \seq_set_split:Nnn \l_tmpa_seq {~} {#1}
  \int_compare:nNnT {\seq_count:N \l_tmpa_seq} > {250} {
      \msg_new:nnn {eas-proc} {abstract-too-long}{Your~abstract~exceeds~the~maximum~length~of~250~words.\\Please~shorten~your~abstract.}
      \msg_error:nn {eas-proc} {abstract-too-long}
    }
  \par
  \bool_gset_true:N \g__ptxcd_skip_hook_bool
  \vskip4.5bp plus .5ex\relax
  \noindent{\color_select:n {peas-blue}\rule{\linewidth}{.5bp}}
  \par\vskip4.5pt
  \usekomafont{abstract}%
  \noindent{\usekomafont{abstractheading}\MakeUppercase{\abstractname}}%
  \par\nobreak
  \vskip1mm
  \@afterindentfalse\@afterheading
  \ignorespaces
  #1
}{
  \par
  \vskip-.5bp
  \noindent{\color_select:n {peas-blue}\rule{\linewidth}{.5bp}}
  \bool_gset_false:N \g__ptxcd_skip_hook_bool
  \par\vskip-1mm plus 1 fil\relax
}
\newenvironment{summary}[2]{
  \par
  \bool_gset_true:N \g__ptxcd_skip_hook_bool
  \vskip4.5bp\relax
  \noindent\begin{minipage}{\linewidth}
    \selectlanguage{estonian}
    \noindent{\color_select:n {peas-blue}\makebox[\linewidth]{\hskip-12mm\rule{\dimexpr\linewidth+24mm}{.5bp}\hskip-12mm}}
    \par\nobreak\vskip4.5pt
    \begin{addmargin}{.5\dimexpr\linewidth-136mm}
      \usekomafont{summary}%
      \noindent{\usekomafont{summaryheading}#1}%
      \par\nobreak
      \vskip3mm
      \par\nobreak
      \noindent{\usekomafont{summaryauthor}#2}
      \vskip3mm
      \@afterindentfalse\@afterheading
      \ignorespaces
      }{
    \end{addmargin}
    \par
    \vskip-.5bp
    \noindent{\color_select:n {peas-blue}\makebox[\linewidth]{\hskip-12mm\rule{\dimexpr\linewidth+24mm}{.5bp}\hskip-12mm}}
  \end{minipage}
  \bool_gset_false:N \g__ptxcd_skip_hook_bool
  \par\vspace*{-1mm}
}
\ExplSyntaxOff

\renewcommand{\sectionlinesformat}[4]{%
  \@hangfrom{\hskip #2#3}{\ignorespaces#4\strut}%
}
\renewcommand*{\sectionformat}{\thesection\autodot\space}
\renewcommand*{\subsectionformat}{\thesubsection\autodot\space}
\renewcommand*{\subsubsectionformat}{\thesubsection\autodot\space}

\renewcommand*{\sectionmarkformat}{}
\renewcommand*{\subsectionmarkformat}{}
\RedeclareSectionCommand[
  beforeskip=\dimexpr9mm-3.5bp\relax,%9mm,%\dimexpr9mm+\baselineskip\relax,
  afterskip=3.5bp,%4pt on second page …
  afterindent=false]{section}
\RedeclareSectionCommand[
  beforeskip=\dimexpr10bp\relax,%9mm,%\dimexpr9mm+\baselineskip\relax,
  afterskip=1.8bp,%4pt on second page …
  afterindent=false]{subsection}
\AddToHook{cmd/subsection/before}{
  \if@nobreak
    \vskip\dimexpr-\lastskip\relax%.5bp
  \fi
}
\normalsize
\setlength{\parindent}{1.5em}% mor than 6 bp in pdf
\def\scr@parindent{1.5em}
\KOMAoptions{captions=tableheading}
\setcapmargin{-12mm}
\setcapindent{0pt}
\setcaptionalignment{l}

\renewcommand{\scr@@makesinglelinecaption}[3]{%
  \usekomafont{caption}{\strut\ignorespaces
    #1{{\usekomafont{captionlabel}{#2\captionformat}}}%
    \ignorespaces #3\strut\unskip}%
}

\renewcommand*{\figureformat}{\figurename~\thefigure\autodot}
\renewcommand*{\tableformat}{\tablename~\thetable\autodot}
\renewcommand*{\captionformat}{\hskip1ex}

\AddToHook{package/babel/after}{
  \addto\extrasbritish {
    \renewcommand*\figurename{Fig.}
  }
  \addto\extrasenglish {
    \renewcommand*\figurename{Fig.}
  }
  \addto\extrasUKenglish {
    \renewcommand*\figurename{Fig.}
  }
  \addto\extrasUSenglish {
    \renewcommand*\figurename{Fig.}
  }
  \renewcommand*\figurename{Fig.}
}

\newcommand*{\journalname}[1]{\def\@journalname{#1}}
\journalname{Proceedings of the\newline Estonian Academy of Sciences}
\newcommand*{\journaldoi}[1]{\def\@journaldoi{#1}}
\journaldoi{10.3176/proc.}
\newcommand*{\@fulldoi}{https://doi.org/\@journaldoi\@doi}
\newcommand*{\journalurl}[1]{\def\@journalurl{#1}}
\journalurl{www.eap.ee/proceedings}
\publishers{Estonian Academy Publishers}

\ExplSyntaxOn
\RenewDocumentCommand{\title}{O{#2}m}{
  \int_compare:nNnT {\exp_args:Ne \tl_count:n {\text_expand:n {#2}}} > {180} {
      \msg_new:nnn {eas-proc} {title-too-long}{Your~title~exceeds~the~maximum~length~of~180~characters.\\Please~use~a~shorter~title.}
      \msg_error:nn {eas-proc} {title-too-long}
    }
  \gdef\@shorttitle{#1}
  \gdef\@title{#2}
}

\newcommand*{\subjfield}[1]{\def\@subjfield{#1}}  %% field of research
\subjfield{}
\newcommand*{\doi}[1]{\def\@doi{#1}}  %% unique part of doi
\doi{}
\newcommand*{\toiminfo}[1]{
  \seq_set_from_clist:Nn \l_tmpa_seq {#1}
  \seq_gpop_left:NN \l_tmpa_seq \@citationyear
  \seq_pop_left:NN \l_tmpa_seq \l_tmpa_tl
  \edef\@toiminfo{
    \@citationyear,~
    \exp_not:N \textbf {\l_tmpa_tl},~
    \seq_use:Nn \l_tmpa_seq {,~}
  }
  \seq_pop_left:NN \l_tmpa_seq \l_tmpb_tl
  \edef\@citationinfo{
    \exp_not:N \textbf {\l_tmpa_tl}(\l_tmpb_tl),~
    \seq_use:Nn \l_tmpa_seq {,~}
  }
} %%{201?, ??, ?, ??--??}   attributes of the edition

\cs_new:Npn \ptxcd_peas_convert_date:w #1 \q_stop{
  \regex_match_case:nnF
  {
    {\d{1,2}\.\d{1,2}\.\d{4}} {\ptxcd_peas_convert_EEdate:w #1\q_stop}
      {\d{4}\-\d{2}\-\d{2}} {\ptxcd_peas_convert_ISOdate:w #1\q_stop}
  }
  {#1}
  {
    \msg_error:nn {eas-proc} {invalid-date-format} {#1}
    #1
  }
}

\msg_new:nnn {eas-proc} {invalid-date-format} {
  Invalid~date~format~`#1`.\\
  You~tried~to~use~\string\chronicle*~without~a~supported~date~format.\\
  Please~use~DD.M.YYYY~as~described~in~the~documentation.
}

\cs_new:Npn \ptxcd_peas_convert_ISOdate:w #1 - #2 - #3 \q_stop{
  {
      \blx@kv@setkeys{blx@opt@pre}{dateabbrev=false}
      \int_eval:n {#3}~\mkbibmonth{#2}~#1
    }
}

\cs_new:Npn \ptxcd_peas_convert_EEdate:w #1 . #2 . #3 \q_stop{
  {
      \blx@kv@setkeys{blx@opt@pre}{dateabbrev=false}
      \int_eval:n {#1}~\mkbibmonth{#2}~#3
    }
}

\toiminfo{201?, ??, ?, ??--??}

\msg_new:nnn {eas-proc} {old-syntax-author} {
  You~used~the~old~syntax~including~manual~setup~of~the~affiliations.\\
  This~means~I~cannot~use~the~automation~to~detect~the~first~author~and~create~a~short-author~entry.\\
  Please~use~the~new~syntax~or~add~a~manual~entry~for~a~short~author~using~the~optional~argument.
}

\newcommand*{\thanksref}[1]{\footref{#1}}
\RenewDocumentCommand{\author}{om}{
\seq_set_split:Nnn \l_tmpa_seq {\and} {#2}
\IfNoValueTF{#1}{
\tl_if_in:nnTF {#2} {\footnotemark} {
\msg_warning:nn {eas-proc} {old-syntax-author}
\begingroup
\renewcommand{\footnotemark}{}
\renewcommand{\corauthref}[1]{}
\global\edef\@shortauthor{
  #2
}
\endgroup
} {
\begingroup
\seq_get_left:NN \l_tmpa_seq \l_tmpa_tl
\cs_set_eq:NN \thanks \use_none:n
\cs_set_eq:NN \footref \use_none:n
\cs_set_eq:NN \label \use_none:n
\tl_set:Ne \l_tmpa_tl {\l_tmpa_tl}
\__ptxcd_create_short_author_aux:N \l_tmpa_tl
\global\edef\@shortauthor{\l_tmpa_tl}
\int_compare:nNnT {\seq_count:N \l_tmpa_seq} = {2}
{
\seq_get_right:NN \l_tmpa_seq \l_tmpa_tl
\__ptxcd_create_short_author_aux:N \l_tmpa_tl
\global\edef\@shortauthor{\@shortauthor\space and\space\l_tmpa_tl}
}
\int_compare:nNnT {\seq_count:N \l_tmpa_seq} > {2} {
    \global\edef\@shortauthor{\@shortauthor\space{et\exp_not:N\,al.}}
  }
\endgroup
}
}{
\gdef\@shortauthor{#1}
}
\global\edef\@author{\seq_use:Nnnn \l_tmpa_seq {~and~} {,~} {~and~}}
\tl_if_eq:NnT \@copyrightauthorstring {default} {
  \int_compare:nNnTF {\seq_count:N \l_tmpa_seq} = {1} {
      \keys_set:nn {ptxcd/eas-proc} {single-author}
    }{
      \keys_set:nn {ptxcd/eas-proc} {multi-author}
    }
}
}

\cs_new:Nn \__ptxcd_create_short_author_aux:N {
  \seq_set_split:NnV \l_tmpb_seq {~} #1
  \seq_pop_right:NN \l_tmpb_seq #1
  \seq_map_inline:Nn \l_tmpb_seq {
    \tl_put_left:Ne #1 {\tl_head:n {##1}.\space}
  }
}

\def\chronicle{\@ifstar\chroniceAutoFormat\chronicleCompat}
\NewDocumentCommand{\chroniceAutoFormat}{mO{}mm}{
  \chronicleCompat
  {\ptxcd_peas_convert_date:w #1\q_stop}
  {#2}
  {\ptxcd_peas_convert_date:w#3\q_stop}
  {\ptxcd_peas_convert_date:w#4\q_stop}
}
\ExplSyntaxOff

\newcommand*{\chronicleCompat}[4]{
  \def\@chronicle{
    Received #1\\
    \ifx#2\@empty\else
      Revision #2\\
    \fi% TODO? Revision #2
    Accepted #3\\
    Available online #4
  }
} %% dates of reception, (revision), acceptance, publication online
\chronicle{}{}{}{}
\newcommand*{\copyrightyear}[1]{\def\@copyrightyear{#1}}%% year of publication
\newcommand*{\copyrightauthorstring}[1]{\def\@copyrightauthorstring{#1}}%% year of publication
\copyrightyear{\the\year}
\newcommand*{\keywords}[1]{\def\@keywords{#1}}%% year of publication
\NewDocumentCommand{\corauth}{om}{
  \gdef\@correspondingAuthor{#2}
  \gdef\@citationAuthor{#1}
}
\newcommand*{\corcontact}[1]{\gdef\@corcontact{#1}}
\corcontact{}
\newcommand*{\journalinfo}[1]{\gdef\@journalinfo{#1}}
\journalinfo{Proceedings of the Estonian Academy of Sciences}
\newcommand*{\citationText}[1]{\def\@citation{#1}}
\citationText{\@citationAuthor\space\@citationyear.\space\@title.\space\textit{\@journalinfo},\space\@citationinfo.\newline%https://doi.org/10.3176/proc.2025.1.01}
  \@fulldoi
}
\newcommand*{\copyrightnotice}[1]{\def\@copyrightnotice{#1}}
\copyrightnotice{© \@copyrightyear{} \@copyrightauthorstring.
  This is an open\\
  access article distributed under the\\
  terms and conditions of the Creative\\
  Commons Attribution (CC BY) license\\
  (http://creativecommons.org/licenses/by/4.0).}

\frenchspacing

\ExplSyntaxOn
\newcommand{\address}[1]{
  \tl_if_in:nnTF {#1} {\footnotemark} {
    \__ptxcd_address_compatibility_aux:w #1 \q_stop
  } {
    \thanks{#1}
  }
}
\cs_new:Npn \__ptxcd_address_compatibility_aux:w  \footnotemark[#1] #2 \q_stop {
  \protected@xdef \@thanks {\@thanks \protect \footnotetext [#1]{\tl_trim_spaces:n {#2}}}
}

\renewcommand{\abstract}{
  \tl_if_eq:NnTF \@currenvir {abstract} {
    \abstractenv
    \let\endabstract\endabstractenv
  } {
    \abstractcommand
  }
}
\newcommand{\abstractcommand}[1]{%
  \def\@abstract{%
    \begin{abstractenv}%
      #1
    \end{abstractenv}%
  }%
}
\let\endabstract\endabstractenv
\def\@abstract{}

\def\corauthref#1{
  \begingroup\def\thefootnote{\fnsymbol{footnote}}\footnotemark[1]
  \corauth{#1}\endgroup
}

\def\TabDimMin{1in}

\newlength{\t@blesize}

\long\def\tbl#1#2{
  \caption{#1}
  \tblmeasure{\usekomafont{table}#2}
}

\newcommand{\tblmeasure}[1]{%
  \def\thefootnote{\fnsymbol{footnote}}%
  \setbox\@tempboxa\hbox{\usekomafont{table}#1}%
  \global\setlength{\t@blesize}{\wd\@tempboxa}
  {\usekomafont{table}#1}
}

\newkomafont{table}{\small}

\AddToHook{env/table/begin}{
  \def\thefootnote{\fnsymbol{footnote}}
  \usekomafont{table}
}

\def\thempfootnote{\@fnsymbol{\c@mpfootnote}}
\NewDocumentCommand{\tblnotes}{m}{%
  \par
  \ifdim\t@blesize=\z@\relax\t@blesize=\linewidth\fi
  \noindent\begin{minipage}[b]{\t@blesize}
    \vskip-\dp\strutbox
    \null\par#1\end{minipage}
  \par
}

\raggedbottom

\ExplSyntaxOff
%% 
%% Copyright (C) 2024-2025 by Marei Peischl <eas-proc@peitex.de>
%% 
%% This work consists of the file eas-proc.dtx and a l3build script named build.lua.
%% 
%%
%% End of file `eas-proc.cls'.
